# Simulateur interactif de transition des pensions - v3.0

Interface graphique pour simuler et visualiser la transition d'un système de pensions par répartition vers un système par capitalisation.

## Installation

```bash
pip install -r requirements.txt
```

## Lancement

```bash
python simulateur_gui.py
```

## Nouveautés v3.0

- **Un fichier YAML par graphique** : Chaque graphique est défini dans son propre fichier
- **Bouton édition (✎)** : Éditez directement le graphique sélectionné
- **Création de graphiques** : Menu > Graphiques > Nouveau graphique
- **Support multi-devises** : Définissez la devise dans le fichier INI (`devise = €`)
- **Aide intégrée** : Liste des champs disponibles dans la sidebar gauche

## Structure

```
gui/
├── simulateur_gui.py       # Application principale
├── requirements.txt        # Dépendances Python
├── README.md              # Ce fichier
└── graphiques/            # Un fichier YAML par graphique
    ├── _template.yaml     # Template pour nouveaux graphiques
    ├── evolution_pib.yaml
    ├── evolution_dettes_pct.yaml
    ├── evolution_dettes_mds.yaml
    ├── evolution_differentiel.yaml
    ├── evolution_interets.yaml
    ├── comparaison_dettes.yaml
    ├── effet_combine_an0.yaml
    └── effet_combine_final.yaml
```

## Fonctionnalités

### Panneau de contrôle (gauche)

- **Sélection du scénario** : Choisissez parmi les fichiers INI disponibles
- **Paramètres modifiables** : Ajustez en temps réel (non sauvegardé)
- **Aide intégrée** : Liste des champs disponibles pour les graphiques

### Affichage des graphiques (droite)

- **4 panneaux indépendants** avec sélecteurs
- **Bouton ✎** : Éditer le fichier YAML du graphique sélectionné
- **Bouton ⤢** : Agrandir le graphique
- **Double-clic** : Agrandir aussi

### Menu Graphiques

- **Nouveau graphique** : Crée un fichier depuis le template
- **Recharger** : Recharge tous les fichiers après modification externe
- **Ouvrir dossier** : Ouvre le dossier graphiques/

## Format des fichiers de graphiques (YAML)

```yaml
# Titre affiché
titre: "Mon graphique"

# Type: line, bar, stacked_bar, area
type: line

# Axes
axe_x:
  champ: annee
  label: "Année"

axe_y:
  label: "Valeur ({devise})"  # {devise} remplacé par €, $, etc.
  min: 0

# Courbes
courbes:
  - champ: pib
    label: "PIB"
    couleur: "#4A90E2"
    style: solid           # solid, dashed, dotted
    remplir: true
    alpha_remplissage: 0.2
```

## Champs disponibles

### Données temporelles
- `annee` - Année de simulation
- `pib` - PIB (Mds)
- `differentiel_pct` - Différentiel (% PIB)
- `interets_totaux` - Intérêts (Mds/an)
- `dette_publique` / `dette_publique_pct` - Dette publique
- `dette_transition` / `dette_transition_pct` - Dette transition
- `dette_publique_totale` / `dette_publique_totale_pct` - Dette totale
- `dette_implicite` / `dette_implicite_pct` - Dette implicite pensions
- `flux_pensions` - Pensions versées (Mds/an)
- `nombre_retraites` - Nombre de retraités

### Variables
- `{devise}` - Symbole de la devise (€, $, £, etc.)

## Configuration de la devise

Dans le fichier INI du scénario, section `[Pays]` :

```ini
[Pays]
nom = Belgique
devise = €
```

Devises supportées : €, $, £, CHF, etc.
