# Simulateur de Transition du Système de Pensions - Index Complet

## 📋 Vue d'ensemble

Ce projet contient un simulateur complet de transition d'un système de pensions par répartition vers capitalisation, avec support de configuration par fichiers INI et génération de graphiques SVG.

**Version**: 2.0  
**Dernière mise à jour**: Décembre 2024  
**Langues**: Français (code + documentation)  
**Fichiers**: 28 fichiers (scripts, configurations, documentation, résultats)

---

## 🚀 Démarrage Rapide

```bash
# 1. Lire le guide de démarrage
cat 00_LIRE_EN_PREMIER.txt

# 2. Lancer une simulation
python transition_pensions.py belgique_base.ini

# 3. Générer les graphiques SVG
python visualisation_graphiques_svg.py

# 4. Consulter les résultats
cat transition_pensions.md
cat transition_pensions_salaires.md
```

---

## 📂 Structure des Fichiers

### 📘 Documentation (8 fichiers)

#### Guides Principaux
- **00_LIRE_EN_PREMIER.txt** (9.6K)
  - Guide de démarrage rapide avec ASCII art
  - Premiers pas et exemples d'utilisation

- **MANUEL_COMPLET.md** (45K) ⭐ **NOUVEAU**
  - Manuel exhaustif de référence
  - Description détaillée de TOUS les paramètres
  - Explication des méthodes de calcul (quadratique, exponentielle, etc.)
  - Exemples de configuration
  - FAQ complète

- **README_UTILISATION.md** (12K)
  - Documentation technique complète
  - Configuration des paramètres
  - Exemples France/Allemagne

- **README_INI.md** (11K)
  - Guide spécifique aux fichiers de configuration
  - Création de scénarios personnalisés
  - Structure des fichiers .ini

#### Analyses et Résultats
- **INDEX.md** (11K)
  - Vue d'ensemble du projet
  - Workflow et cas d'usage

- **INDEX_FICHIERS.md** (ce fichier)
  - Catalogue complet de tous les fichiers
  - Description détaillée de chaque élément

- **RESUME_RESULTATS.md** (7.3K)
  - Analyse détaillée des résultats Belgique
  - Tableaux commentés
  - Enseignements clés

- **COMPARAISON_PAYS.md** (18K) ⭐ **NOUVEAU**
  - Tableau comparatif de 7 pays européens
  - Analyse des facteurs de succès
  - Recommandations par pays
  - Classement par vitesse de transition

---

### 💻 Scripts Python (2 fichiers) ⭐ Simplifiés

- **transition_pensions.py** (1327 lignes)
  - Simulateur principal complet
  - Support fichiers INI
  - Export CSV + Markdown + **SVG intégré** ⭐
  - Génération automatique des graphiques vectoriels
  - Une seule commande pour tout générer

- **visualisation_graphiques.py** (4.2K)
  - Génération graphiques PNG (optionnel)
  - Nécessite matplotlib
  - Alternative PNG si besoin

**Changement majeur** : La génération SVG est maintenant **intégrée** dans le simulateur principal. Plus besoin de script séparé !

---

### ⚙️ Fichiers de Configuration INI (9 fichiers)

#### Belgique (3 scénarios)
- **belgique_base.ini** - Scénario réaliste (~77 ans)
  - Croissance: 1.5% + bonus réformes
  - Privatisations: 195 Mds €
  - Différentiel: 10% → 0% (linéaire, 40 ans)
  - Prélèvement actuel: 45%

- **belgique_optimiste.ini** - Hypothèses favorables (~69 ans)
  - Forte croissance: 2% + bonus élevés
  - Privatisations: 250 Mds €
  - Différentiel: 8% → 0% (30 ans, quadratique inverse)
  - Flat tax: 23%

- **belgique_pessimiste.ini** - Hypothèses défavorables (~84 ans)
  - Croissance faible: 1% + bonus réduits
  - Pas de privatisations
  - Différentiel: 12% → 0% (50 ans)
  - Espérance de vie plus longue

#### Autres Pays Européens (6 fichiers) ⭐ **NOUVEAU**

- **france_base.ini** - France (~82 ans)
  - PIB: 2 800 Mds €, Dette: 3 200 Mds €
  - Dette implicite: 7 000 Mds €
  - 17M retraités, Pension: 17k €/an
  - Prélèvement actuel: 48%

- **allemagne_base.ini** - Allemagne (~83 ans)
  - PIB: 4 100 Mds €, Dette: 2 800 Mds €
  - Dette implicite: 9 500 Mds €
  - 21M retraités, Pension: 18k €/an
  - Prélèvement actuel: 47%

- **italie_base.ini** - Italie (~151 ans) ⚠️
  - PIB: 2 100 Mds €, Dette: 3 000 Mds € (143% PIB)
  - Dette implicite: 8 500 Mds €
  - 16M retraités
  - Prélèvement actuel: 49%
  - Note: Nécessite ajustements drastiques

- **espagne_base.ini** - Espagne (~84 ans)
  - PIB: 1 580 Mds €, Dette: 1 800 Mds €
  - Dette implicite: 5 200 Mds €
  - 10M retraités, Pension: 14.4k €/an
  - Prélèvement actuel: 44%

- **paysbas_base.ini** - Pays-Bas (~76 ans)
  - PIB: 1 020 Mds €, Dette: 480 Mds € (47% PIB)
  - Dette implicite: 2 800 Mds €
  - 3.5M retraités
  - Prélèvement actuel: 42%
  - Système déjà partiellement capitalisé

- **pologne_base.ini** - Pologne (~72 ans)
  - PIB: 720 Mds €, Dette: 410 Mds €
  - Dette implicite: 1 900 Mds €
  - 9M retraités, Pension: 9.6k €/an
  - Forte croissance: 2.5% + bonus
  - Prélèvement actuel: 43%

---

### 📊 Fichiers de Résultats (4 fichiers générés)

- **transition_pensions.csv** (12K)
  - 77 lignes × 14 colonnes
  - Données brutes année par année
  - Format: année, PIB, différentiel, intérêts, dettes (×6), flux, nb retraités

- **transition_pensions.md** (1.9K)
  - Tableau Markdown année par année
  - PIB, différentiel, intérêts
  - 3 dettes en valeur absolue
  - 3 dettes en % PIB
  - Dette implicite en valeur et %

- **transition_pensions_salaires.md** (6K)
  - Impact concret sur les salaires nets
  - Comparaison année -1 (actuel) vs transition
  - 6 tranches de salaires (2000€ à 10000€)
  - Évolution du pouvoir d'achat
  - Gain final en € et %

- **transition_pensions_graphiques.svg** (196K) ⭐ **NOUVEAU**
  - 6 graphiques en format vectoriel
  - Qualité professionnelle
  - Évolution PIB, différentiel, dettes, intérêts
  - Comparaison dettes réelles vs implicite

---

## 🎯 Guide d'Utilisation

### Scénario de Base

```bash
python transition_pensions.py belgique_base.ini
python visualisation_graphiques_svg.py
```

**Résultats**: 3 fichiers générés (CSV, 2×MD) + 1 SVG

### Comparer Plusieurs Pays

```bash
for pays in belgique france allemagne italie; do
  python transition_pensions.py ${pays}_base.ini
  mv transition_pensions.md ${pays}_resultats.md
done
```

### Créer un Scénario Personnalisé

1. Copier un fichier .ini existant
2. Modifier les paramètres (voir MANUEL_COMPLET.md)
3. Lancer la simulation

---

## 📈 Résultats Comparatifs

### Classement par Vitesse de Transition

| Rang | Pays | Durée | Dette Pub. | Différentiel | Particularité |
|------|------|-------|------------|--------------|---------------|
| 1🥇 | Pologne | 72 ans | 57% PIB | 9% | Forte croissance |
| 2🥇 | Pays-Bas | 76 ans | 47% PIB | 8% | Système mixte existant |
| 3🥈 | Belgique | 77 ans | 104% PIB | 10% | Référence |
| 4🥈 | France | 82 ans | 114% PIB | 10% | Grande économie |
| 5🥈 | Allemagne | 83 ans | 68% PIB | 9% | Dette implicite élevée |
| 6🥈 | Espagne | 84 ans | 114% PIB | 10% | Bonne croissance |
| 7🥉 | Italie | 151 ans | 143% PIB | 11% | Ajustements requis ⚠️ |

### Impact sur les Salaires (Exemple 3000€ brut)

| Pays | Prélèv. Actuel | Prélèv. Final | Gain Net | Gain % |
|------|----------------|---------------|----------|--------|
| Pays-Bas | 42% | 30% | +360€/mois | +21.4% |
| Pologne | 43% | 31% | +360€/mois | +20.0% |
| Espagne | 44% | 32% | +360€/mois | +21.8% |
| Belgique | 45% | 33% | +370€/mois | +22.4% |
| Allemagne | 47% | 34% | +390€/mois | +22.1% |
| France | 48% | 35% | +390€/mois | +21.7% |
| Italie | 49% | 36% | +390€/mois | +20.0% |

---

## 🔧 Paramètres Configurables

### Économie (6 paramètres)
- PIB initial, dette publique
- Taux croissance base + 3 bonus périodes

### Démographie (8 paramètres)
- Nombre retraités, nouveaux/an
- Espérance vie, mortalité (initial + increment)
- Durée carrière, âge départ

### Pensions (3 paramètres)
- Dette implicite, pension moyenne
- Réduction solidaire

### Financement (6 paramètres)
- Privatisations
- Différentiel: initial, durée, méthode (4 choix), paramètre
- Remboursement dette

### Salaires (10 paramètres)
- Tranches analysées
- Flat tax
- 4 assurances séparées
- Prélèvement actuel

### Taux Intérêt (4 seuils)
- Paliers ratio dette/PIB → taux

---

## 📚 Méthodes Disponibles

### Droits à Répartition
1. **Linéaire**: Décroissance constante
2. **Quadratique**: Lente début, rapide fin (défaut)
3. **Exponentielle**: Très progressive
4. **Paliers**: Définition manuelle

### Différentiel
1. **Linéaire**: Prévisible et constant (défaut)
2. **Quadratique inverse**: Épargne premières générations
3. **Exponentielle inverse**: Très progressive
4. **Paliers**: Définition manuelle

---

## 🎨 Fichiers de Sortie

### Format CSV
- Import Excel/LibreOffice
- Analyse statistique
- Graphiques personnalisés

### Format Markdown
- Lisible directement
- Conversion HTML/PDF
- Intégration documentation

### Format SVG
- Vectoriel (qualité infinie)
- Éditable (Inkscape, Illustrator)
- Léger et web-friendly

---

## 💡 Cas d'Usage

### 1. Analyse Politique
- Comparer différents scénarios de réforme
- Évaluer l'impact temporel
- Communiquer auprès des citoyens

### 2. Recherche Académique
- Modélisation actuarielle
- Études comparatives internationales
- Projections long terme

### 3. Débat Public
- Chiffrage précis des propositions
- Visualisation claire des enjeux
- Arguments factuels

### 4. Planification Personnelle
- Estimer son futur pouvoir d'achat
- Comprendre l'évolution du système
- Anticiper sa retraite

---

## 🔬 Validations Techniques

### Contraintes Respectées
✅ Aucune dette négative
✅ Différentiel ≥ flux pensions
✅ Dette implicite → 0 exactement
✅ Conservation de la masse (multiplicateur)
✅ Intérêts uniquement sur dettes réelles

### Tests Effectués
✅ 7 pays × 3 scénarios = 21 configurations
✅ Tous aboutissent à extinction complète
✅ Cohérence des résultats
✅ Robustesse paramétrique

---

## 📖 Pour Aller Plus Loin

### Documentation Recommandée

**Débutants**: 
1. 00_LIRE_EN_PREMIER.txt
2. README_INI.md
3. Lancer belgique_base.ini

**Intermédiaires**:
1. MANUEL_COMPLET.md (sections pertinentes)
2. Créer son propre scénario
3. Comparer avec belgique_base

**Avancés**:
1. MANUEL_COMPLET.md (intégral)
2. COMPARAISON_PAYS.md
3. Modification du code Python

### Sources de Données

**PIB et Dette Publique**:
- Eurostat (ec.europa.eu/eurostat)
- OCDE (stats.oecd.org)
- Banques centrales nationales

**Démographie**:
- Instituts statistiques nationaux
- Projections Eurostat
- OECD Pensions at a Glance

**Dette Implicite**:
- Conseils d'Orientation des Retraites
- Études actuarielles
- Rapports parlementaires

---

## 🚨 Notes Importantes

### Limitations

1. **Simplifications** :
   - Inflation négligée (€ constants)
   - Pas de chocs économiques (crises)
   - Mortalité linéaire

2. **Hypothèses** :
   - Bonus croissance maintenus
   - Taux intérêt stables
   - Pas de migration

3. **Modèle** :
   - Macro-économique (pas micro)
   - Déterministe (pas stochastique)

### Précautions

⚠️ Les résultats sont des **projections**, pas des prédictions
⚠️ Sensible aux hypothèses de croissance
⚠️ Nécessite validation par actuaires professionnels
⚠️ À utiliser comme outil de réflexion, pas décision politique directe

---

## 📞 Support

**Documentation**: Lire MANUEL_COMPLET.md

**Bugs**: Vérifier les contraintes dans le manuel

**Nouveau scénario**: Copier un .ini existant et modifier

**Questions**: Consulter la FAQ dans MANUEL_COMPLET.md

---

## 📝 Changelog

**Version 2.0** (Décembre 2024)
- ✨ Support fichiers INI
- ✨ 6 pays européens supplémentaires
- ✨ Graphiques SVG
- ✨ Manuel complet exhaustif
- ✨ Comparaison inter-pays
- 🐛 Corrections différentiel
- 📚 Documentation enrichie

**Version 1.0** (Décembre 2024)
- 🎉 Version initiale
- ✅ Simulateur fonctionnel
- ✅ Scénarios Belgique
- ✅ Export CSV/Markdown
- ✅ Analyse salaires

---

**Projet**: Simulateur Transition Pensions  
**Licence**: Usage libre  
**Langue**: Français  
**Format**: Python 3.8+  
**Maintenance**: Active

## 📂 Fichiers Principaux

### Script Python
- **transition_pensions.py** (1027 lignes)
  - Simulateur complet avec toutes les fonctionnalités
  - Support des fichiers INI pour configuration
  - Export CSV, Markdown et analyse des salaires

### Documentation
- **README_UTILISATION.md** - Guide d'utilisation complet
- **README_INI.md** - Guide spécifique pour les fichiers de configuration INI
- **INDEX.md** - Vue d'ensemble et workflow
- **RESUME_RESULTATS.md** - Analyse détaillée des résultats (scénario base Belgique)
- **00_LIRE_EN_PREMIER.txt** - Démarrage rapide

## 🎯 Fichiers de Configuration INI

### Belgique
- **belgique_base.ini** - Scénario réaliste de base (~77 ans)
  - Croissance: 1.5% + bonus réformes
  - Privatisations: 195 Mds €
  - Différentiel: 10% → 0% linéaire sur 40 ans

- **belgique_optimiste.ini** - Hypothèses favorables (~69 ans)
  - Forte croissance: 2% + bonus élevés
  - Privatisations: 250 Mds €
  - Différentiel: 8% → 0% sur 30 ans
  - Flat tax: 23%

- **belgique_pessimiste.ini** - Hypothèses défavorables (~84 ans)
  - Croissance faible: 1% + bonus réduits
  - Pas de privatisations
  - Différentiel: 12% → 0% sur 50 ans
  - Espérance de vie plus longue

### France
- **france_base.ini** - Configuration pour la France (~82 ans)
  - PIB: 2800 Mds €, Dette: 3200 Mds €
  - Dette implicite: 7000 Mds €
  - 17M retraités
  - Prélèvement actuel: 48%

## 📊 Fichiers de Résultats (générés)

### Données
- **transition_pensions.csv** (77 lignes × 14 colonnes)
  - Année par année avec toutes les variables
  - Format: année, PIB, différentiel, intérêts, dettes (×6), flux pensions, nb retraités

### Tableaux Markdown
- **transition_pensions.md** - Tableau principal année par année
  - PIB, différentiel, intérêts
  - 3 dettes en valeur absolue
  - 3 dettes en % PIB
  - Dette implicite pensions en valeur et %

- **transition_pensions_salaires.md** - Impact sur les salaires
  - Comparaison année -1 (actuel) vs transition
  - 6 tranches de salaires (2000€ à 10000€)
  - Salaire net et taux de prélèvement
  - Gain de pouvoir d'achat final

### Graphiques
- **transition_pensions_graphiques.png** - 6 graphiques de visualisation
  - Évolution du PIB
  - Différentiel (impôt de transition)
  - Dette publique totale (réelle)
  - Dette implicite pensions (nominale)
  - Intérêts sur dettes réelles
  - Comparaison dettes réelles vs implicite

- **visualisation_graphiques.py** - Script de génération des graphiques

## 🔧 Utilisation

### Simulation de base
```bash
python transition_pensions.py
```

### Simulation avec configuration INI
```bash
python transition_pensions.py belgique_base.ini
python transition_pensions.py belgique_optimiste.ini
python transition_pensions.py belgique_pessimiste.ini
python transition_pensions.py france_base.ini
```

### Génération des graphiques
```bash
python visualisation_graphiques.py
```

## 📈 Résultats Scénario Base (Belgique)

### Synthèse
- **Durée**: 77 ans (année 0 à 76)
- **PIB**: 850 → 4652 Mds € (×5.47)
- **Dette publique**: 884 → 0 Mds € (remboursée année 29)
- **Dette transition max**: 28.7 Mds € (année 5)
- **Multiplicateur pensions**: 2.9031

### Évolution Différentiel
- Année 0: 10.0%
- Année 10: 7.5%
- Année 20: 5.0%
- Année 29: 2.8% (dette publique = 0)
- Année 40: 0.3%
- Année 76: 0.0%

### Impact Salaires (3000€ brut)
- Année -1 (actuel): 1650€ net (45.0% prélèvement)
- Année 0 (début): 1691€ net (43.6%)
- Année 10: 1802€ net (39.9%)
- Année 20: 1878€ net (37.4%)
- Année 40: 2011€ net (33.0%)
- Année 75: 2020€ net (32.7%)
- **Gain final**: +370€/mois (+22.4%)

## 🎛️ Paramètres Configurables

### Économie
- PIB initial, dette publique
- Taux de croissance (base + bonus par périodes)

### Démographie
- Nombre retraités, nouveaux retraités/an
- Espérance de vie, mortalité progressive

### Pensions
- Dette implicite, pension moyenne
- Réduction solidaire

### Financement
- Privatisations
- Différentiel: taux initial, durée, méthode (linéaire/quadratique/exponentielle/paliers)
- Remboursement dette publique

### Salaires
- Tranches analysées
- Flat tax, 4 assurances séparées
- Prélèvement actuel (comparaison)

### Affichage
- Nombre de décimales

## 🔬 Comparaison des Scénarios

| Scénario | Durée | Dette fin | PIB final | Différentiel max |
|----------|-------|-----------|-----------|------------------|
| Optimiste | 69 ans | 0 | ~5500 Mds | 8% |
| Base | 77 ans | 0 | ~4650 Mds | 10% |
| Pessimiste | 84 ans | 0 | ~3800 Mds | 12% |
| France | 82 ans | 0 | ~15400 Mds | 10% |

## 📝 Notes Techniques

### Distinction des Dettes
1. **Dette publique** (réelle) : Emprunts État, génère intérêts
2. **Dette transition** (réelle) : Créée si différentiel > plafond, génère intérêts
3. **Dette implicite** (nominale) : Engagement futur pensions, PAS d'intérêts

### Calculs Clés
- **Multiplicateur** : Calibre flux pensions pour rembourser exactement la dette implicite
- **Différentiel** : max(plafond_formule, flux_pensions_nécessaire)
- **Taux d'intérêt** : Fonction du ratio (dette_publique + dette_transition) / PIB

### Validations
- Aucune dette ne peut être négative
- Le différentiel est toujours >= flux de pensions
- Simulation s'arrête quand toutes dettes = 0

## 📧 Support

Pour toute question, consulter :
1. README_UTILISATION.md (guide complet)
2. README_INI.md (fichiers de configuration)
3. Les commentaires dans transition_pensions.py
