# MANUEL COMPLET - Simulateur de Transition du Système de Pensions

## Table des Matières

1. [Vue d'ensemble](#vue-densemble)
2. [Installation et Utilisation](#installation-et-utilisation)
3. [Référence des Paramètres](#référence-des-paramètres)
4. [Méthodes de Calcul](#méthodes-de-calcul)
5. [Exemples de Configuration](#exemples-de-configuration)
6. [Interprétation des Résultats](#interprétation-des-résultats)
7. [FAQ](#faq)

---

## Vue d'ensemble

### Objectif

Ce simulateur modélise la transition complète d'un système de pensions par répartition (actuel) vers un système par capitalisation, en calculant année par année l'évolution sur plusieurs décennies jusqu'à extinction du système de répartition.

### Principe de Fonctionnement

**Année -1** : Système actuel (répartition)
- Les actifs cotisent pour payer les retraités actuels
- Prélèvement: ~45-48% (cotisations + impôts)

**Année 0** : Début de la réforme
- Flat tax remplace les cotisations
- Différentiel temporaire pour financer les anciens retraités
- Les nouveaux cotisants capitalisent pour eux-mêmes

**Années 1-40** : Transition
- Le différentiel diminue progressivement
- La dette publique se rembourse
- Les anciens retraités s'éteignent progressivement

**Année finale** : Système stabilisé
- Différentiel = 0%
- Toutes les dettes remboursées
- Capitalisation pleinement opérationnelle

---

## Installation et Utilisation

### Prérequis

```bash
python3 --version  # Python 3.8 ou supérieur
```

### Utilisation Basique

```bash
# Sans configuration (paramètres par défaut)
python transition_pensions.py

# Avec fichier de configuration
python transition_pensions.py belgique_base.ini
```

### Génération des Graphiques

```bash
# PNG (matplotlib requis)
python visualisation_graphiques.py

# SVG (aucune dépendance)
python visualisation_graphiques_svg.py
```

---

## Référence des Paramètres

### Section [Pays]

#### `nom`
- **Type**: Texte
- **Exemple**: `Belgique`, `France`, `Allemagne`
- **Description**: Nom du pays ou du scénario
- **Impact**: Affiché dans les résultats uniquement

#### `description`
- **Type**: Texte
- **Exemple**: `Scénario de base pour la Belgique`
- **Description**: Description libre du scénario
- **Impact**: Documentation uniquement

---

### Section [Economie]

#### `pib_initial`
- **Type**: Nombre décimal
- **Unité**: Milliards d'euros
- **Exemple**: `850.0` (Belgique), `2800.0` (France), `4100.0` (Allemagne)
- **Description**: PIB nominal de l'année 0
- **Source**: Données OCDE, Eurostat ou Banque Mondiale
- **Impact**: Base de calcul du différentiel et des ratios dette/PIB

#### `dette_publique_initiale`
- **Type**: Nombre décimal
- **Unité**: Milliards d'euros
- **Exemple**: `884.0` (Belgique = 104% PIB)
- **Description**: Dette publique existante (emprunts de l'État)
- **Source**: Banques centrales, ministères des finances
- **Impact**: Génère des intérêts, remboursée progressivement
- **Note**: Dette RÉELLE qui génère des intérêts

#### `taux_croissance_base`
- **Type**: Nombre décimal (fraction)
- **Plage**: 0.005 à 0.030 (0.5% à 3%)
- **Exemple**: `0.015` = 1.5%/an
- **Description**: Taux de croissance annuel du PIB de base
- **Recommandations**:
  - **Pessimiste**: 0.008-0.012 (0.8-1.2%)
  - **Réaliste**: 0.012-0.018 (1.2-1.8%)
  - **Optimiste**: 0.018-0.025 (1.8-2.5%)
- **Impact**: Croissance du PIB appliquée chaque année

#### `bonus_croissance_1_10`
- **Type**: Nombre décimal (fraction)
- **Plage**: 0.000 à 0.030
- **Exemple**: `0.02` = +2%/an supplémentaire
- **Description**: Bonus de croissance années 1-10 (effet réformes)
- **Justification**: Les réformes structurelles génèrent de la croissance
- **Impact**: S'ajoute au taux de base pendant 10 ans

#### `bonus_croissance_11_20`
- **Type**: Nombre décimal (fraction)
- **Exemple**: `0.01` = +1%/an
- **Description**: Bonus années 11-20 (effet qui s'estompe)

#### `bonus_croissance_20_plus`
- **Type**: Nombre décimal (fraction)
- **Exemple**: `0.005` = +0.5%/an
- **Description**: Bonus années 21+ (effet résiduel permanent)

---

### Section [Pensions]

#### `dette_implicite_initiale`
- **Type**: Nombre décimal
- **Unité**: Milliards d'euros
- **Exemple**: `2100.0` (Belgique), `7000.0` (France)
- **Description**: Valeur actuelle des pensions futures promises
- **Calcul estimatif**: 
  ```
  nombre_retraités × pension_moyenne × espérance_vie_restante
  + VAN(nouveaux_retraités_futurs)
  ```
- **Source**: Rapports Conseil d'Orientation des Retraites, études actuarielles
- **Impact**: Dette NOMINALE qui NE génère PAS d'intérêts
- **Note**: Diminue uniquement quand on paie les flux de pensions

#### `reduction_solidaire`
- **Type**: Nombre décimal (fraction)
- **Plage**: 0.00 à 0.20 (0% à 20%)
- **Exemple**: `0.10` = réduction de 10%
- **Description**: Réduction appliquée aux pensions pour soutenabilité
- **Justification**: Ajustement équitable du système
- **Impact**: Réduit la dette implicite ET les flux de pensions
- **Application**: Dette_réelle = Dette_initiale × (1 - reduction)

#### `nombre_retraites_initiaux`
- **Type**: Entier
- **Exemple**: `2500000` (Belgique), `17000000` (France)
- **Description**: Nombre de retraités à l'année 0
- **Source**: Instituts statistiques nationaux
- **Impact**: Base de calcul des flux de pensions

#### `pension_moyenne_annuelle`
- **Type**: Nombre décimal
- **Unité**: Euros par an
- **Exemple**: `15000.0` (Belgique = 1250€/mois)
- **Description**: Pension brute moyenne par retraité
- **Calcul**: Pension_mensuelle × 12
- **Impact**: Détermine le flux annuel de pensions
- **Note**: Après application de la réduction solidaire

#### `nouveaux_retraites_par_an`
- **Type**: Entier
- **Exemple**: `100000` (Belgique), `700000` (France)
- **Description**: Nombre de nouveaux départs à la retraite chaque année
- **Source**: Projections démographiques
- **Impact**: Augmente le nombre total de retraités chaque année

#### `duree_carriere`
- **Type**: Entier
- **Unité**: Années
- **Exemple**: `40`
- **Description**: Durée de carrière complète pour droits pleins
- **Impact**: Calcul des droits proportionnels à la répartition
- **Note**: Nouveaux retraités année N ont travaillé (40-N) ans dans l'ancien système

#### `age_depart_retraite`
- **Type**: Entier
- **Unité**: Années
- **Exemple**: `65` (Belgique), `64` (France)
- **Description**: Âge légal de départ à la retraite
- **Impact**: Documentation uniquement (calcul mortalité)

#### `age_esperance_vie`
- **Type**: Entier
- **Unité**: Années
- **Exemple**: `85` (espérance = 20 ans après retraite)
- **Description**: Espérance de vie moyenne
- **Impact**: Durée moyenne de versement des pensions
- **Note**: Utilisé pour estimer la mortalité

---

### Section [Mortalite]

#### `taux_mortalite_initial`
- **Type**: Nombre décimal (fraction)
- **Plage**: 0.03 à 0.08 (3% à 8%)
- **Exemple**: `0.05` = 5% la première année de retraite
- **Description**: Taux de mortalité des nouveaux retraités
- **Impact**: Détermine la décroissance du nombre de retraités
- **Formule**: 
  ```
  mortalite(année_depuis_retraite) = taux_initial + (année × increment)
  ```

#### `increment_mortalite_annuel`
- **Type**: Nombre décimal (fraction)
- **Plage**: 0.002 à 0.005
- **Exemple**: `0.003` = +0.3%/an
- **Description**: Augmentation annuelle du taux de mortalité
- **Impact**: La mortalité augmente avec l'âge
- **Exemple concret**:
  ```
  Année 0 après retraite: 5.0%
  Année 5 après retraite: 6.5%
  Année 10 après retraite: 8.0%
  Année 20 après retraite: 11.0%
  ```

---

### Section [DroitsRepartition]

Cette section contrôle comment les droits à la répartition diminuent pour les nouveaux retraités.

**Principe**: Un salarié qui a travaillé 40 ans dans l'ancien système a 100% de droits. Un salarié qui n'a travaillé que 20 ans dans l'ancien système a des droits réduits.

#### `methode_droits`
- **Type**: Texte
- **Valeurs possibles**: `quadratique`, `exponentielle`, `lineaire`, `paliers`
- **Défaut**: `quadratique`
- **Description**: Méthode de calcul des droits proportionnels

##### Méthode `quadratique`

**Formule**:
```
droits = duree_carriere × ((annees_restantes / duree_carriere) ^ exposant)
```

**Paramètre**: `parametre_methode_droits` = exposant (défaut 1.5)

**Comportement**:
- **Exposant < 1**: Décroissance rapide au début, lente à la fin
- **Exposant = 1**: Décroissance linéaire (équivalent à méthode `lineaire`)
- **Exposant > 1**: Décroissance lente au début, rapide à la fin

**Exemple avec exposant = 1.5**:
```
Année  1: (39/40)^1.5 × 40 = 39.75 ans de droits
Année  5: (35/40)^1.5 × 40 = 36.73 ans
Année 10: (30/40)^1.5 × 40 = 32.66 ans
Année 20: (20/40)^1.5 × 40 = 22.36 ans
Année 30: (10/40)^1.5 × 40 = 10.00 ans
Année 40: (0/40)^1.5 × 40 = 0.00 ans
```

**Justification**: Reflète le fait que capitaliser sur 5 ans rapporte peu, donc droits répartition ne peuvent pas baisser linéairement.

##### Méthode `exponentielle`

**Formule**:
```
droits = duree_carriere × exp(-taux × (annee - 1))
```

**Paramètre**: `parametre_methode_droits` = taux de décroissance (défaut 0.05)

**Comportement**: Décroissance exponentielle très progressive

**Exemple avec taux = 0.05**:
```
Année  1: 40 × exp(-0.05×0) = 40.00 ans
Année 10: 40 × exp(-0.05×9) = 25.31 ans
Année 20: 40 × exp(-0.05×19) = 15.48 ans
Année 40: 40 × exp(-0.05×39) = 5.79 ans
```

##### Méthode `lineaire`

**Formule**:
```
droits = duree_carriere × (annees_restantes / duree_carriere)
```

**Paramètre**: Ignoré (pas de paramètre)

**Exemple**:
```
Année  1: 39 ans
Année 10: 30 ans
Année 20: 20 ans
Année 40: 0 ans
```

##### Méthode `paliers`

**Paramètre**: Liste de tuples `[(annee, droits_années), ...]`

**Exemple**:
```ini
parametre_methode_droits = [(5, 39), (10, 37), (20, 30), (30, 20), (40, 0)]
```

**Comportement**: Paliers définis manuellement

#### `parametre_methode_droits`
- **Type**: Nombre ou liste (selon méthode)
- **Défaut**: `-1` (utilise valeur par défaut de la méthode)
- **Description**: Paramètre de la méthode choisie

---

### Section [Financement]

#### `privatisations_totales`
- **Type**: Nombre décimal
- **Unité**: Milliards d'euros
- **Plage**: 0 à 500 (selon taille du pays)
- **Exemple**: `195.0` (Belgique), `0.0` (scénario pessimiste)
- **Description**: Montant des actifs publics vendus
- **Impact**: Rembourse immédiatement la dette publique année 1
- **Exemples d'actifs**:
  - Participations État dans entreprises
  - Infrastructures (autoroutes, aéroports)
  - Bâtiments publics non-essentiels
  - Terrains domaniaux

#### `differentiel_initial`
- **Type**: Nombre décimal (fraction)
- **Plage**: 0.05 à 0.15 (5% à 15%)
- **Exemple**: `0.10` = 10% du PIB
- **Description**: Impôt temporaire maximum pour financer la transition
- **Impact**: Plafond année 0 du différentiel
- **Justification**: Protège les citoyens d'un choc fiscal brutal

#### `duree_decroissance_differentiel`
- **Type**: Entier
- **Unité**: Années
- **Plage**: 20 à 60
- **Exemple**: `40`
- **Description**: Durée sur laquelle le différentiel décroît jusqu'à 0
- **Impact**: Détermine la vitesse de baisse du différentiel
- **Recommandations**:
  - **Court** (20-30 ans): Transition rapide, effort concentré
  - **Moyen** (30-45 ans): Équilibre
  - **Long** (45-60 ans): Effort très étalé

#### `methode_differentiel`
- **Type**: Texte
- **Valeurs**: `lineaire`, `quadratique_inverse`, `exponentielle_inverse`, `paliers`
- **Défaut**: `lineaire`

##### Méthode `lineaire`

**Formule**:
```
plafond = differentiel_initial × (1 - annee / duree)
```

**Exemple** (10% sur 40 ans):
```
Année  0: 10.00%
Année 10:  7.50%
Année 20:  5.00%
Année 30:  2.50%
Année 40:  0.00%
```

**Caractéristiques**: Prévisible, baisse constante

##### Méthode `quadratique_inverse`

**Formule**:
```
plafond = differentiel_initial × ((duree - annee) / duree) ^ exposant
```

**Paramètre**: exposant (défaut 1.5)

**Exemple** (exposant = 1.5):
```
Année  0: 10.00%
Année 10:  8.66%
Année 20:  6.12%
Année 30:  3.06%
Année 40:  0.00%
```

**Caractéristiques**: Baisse lente au début (épargne les premières générations), rapide à la fin

##### Méthode `exponentielle_inverse`

**Formule**:
```
plafond = differentiel_initial × exp(-taux × annee)
```

**Paramètre**: taux (défaut 0.05)

**Exemple** (taux = 0.05):
```
Année  0: 10.00%
Année 10:  6.07%
Année 20:  3.68%
Année 40:  1.35%
```

**Caractéristiques**: Décroissance très progressive, jamais vraiment 0

##### Méthode `paliers`

**Paramètre**: Liste `[(annee, differentiel), ...]`

**Exemple**:
```ini
parametre_methode_differentiel = [(10, 0.09), (20, 0.07), (30, 0.04), (40, 0.0)]
```

#### `parametre_methode_differentiel`
- **Type**: Nombre ou liste
- **Défaut**: `-1`
- **Description**: Paramètre de la méthode de différentiel

#### `remboursement_dette_pub_pct_pib`
- **Type**: Nombre décimal (fraction)
- **Plage**: 0.005 à 0.020 (0.5% à 2%)
- **Exemple**: `0.01` = 1% du PIB par an
- **Description**: Remboursement annuel "normal" de la dette publique
- **Impact**: S'ajoute au remboursement par excédent du différentiel
- **Note**: La dette ne peut jamais devenir négative

---

### Section [TauxInteret]

Cette section définit les paliers de taux d'intérêt en fonction du ratio dette/PIB.

**Format**: `seuil_X = ratio_max, taux_min, taux_max`

**Principe**: Le taux d'intérêt augmente quand le ratio dette/PIB augmente (prime de risque).

**Exemple**:
```ini
seuil_1 = 0.60, 0.015, 0.020
seuil_2 = 0.90, 0.020, 0.025
seuil_3 = 1.20, 0.025, 0.030
seuil_4 = 9.99, 0.030, 0.040
```

**Interprétation**:
- **Ratio 0-60%**: Taux entre 1.5% et 2.0%
- **Ratio 60-90%**: Taux entre 2.0% et 2.5%
- **Ratio 90-120%**: Taux entre 2.5% et 3.0%
- **Ratio >120%**: Taux entre 3.0% et 4.0%

**Interpolation**: Linéaire dans chaque palier

**Impact**: Plus la dette est élevée, plus elle coûte cher (cercle vertueux/vicieux)

---

### Section [Salaires]

#### `generer_tableau_salaires`
- **Type**: Booléen
- **Valeurs**: `true` ou `false`
- **Description**: Génère ou non le tableau d'analyse des salaires

#### `fichier_tableau_salaires`
- **Type**: Texte
- **Exemple**: `transition_pensions_salaires.md`
- **Description**: Nom du fichier de sortie

#### `salaires_analyses`
- **Type**: Liste de nombres
- **Unité**: Euros par mois (brut)
- **Exemple**: `2000, 3000, 4000, 5000, 7000, 10000`
- **Description**: Tranches de salaires à analyser
- **Recommandation**: 4 à 8 tranches couvrant l'éventail des salaires

#### `taux_flat_tax`
- **Type**: Nombre décimal (fraction)
- **Plage**: 0.15 à 0.30 (15% à 30%)
- **Exemple**: `0.25` = 25%
- **Description**: Taux de l'impôt proportionnel unique
- **Impact**: Remplace cotisations sociales + impôt sur le revenu
- **Recommandations**:
  - **Bas** (20-23%): Attractif mais nécessite ajustements
  - **Moyen** (23-27%): Équilibré
  - **Haut** (27-30%): Conservateur

#### `assurance_sante`
#### `assurance_chomage`
#### `assurance_pension`
#### `assurance_education`
- **Type**: Nombre décimal
- **Unité**: Euros par mois
- **Exemple**: `80.0`, `40.0`, `60.0`, `50.0`
- **Description**: Coût mensuel de chaque assurance
- **Impact**: Prélevé sur le salaire brut
- **Note**: Montants fixes (non proportionnels au salaire)
- **Justification séparation**:
  - Santé: Peut varier selon situation familiale
  - Chômage: Peut être optionnel selon statut
  - Pension: Capitalisation individuelle
  - Éducation: Variable selon nombre d'enfants

#### `prelevement_actuel_total`
- **Type**: Nombre décimal (fraction)
- **Plage**: 0.40 à 0.55
- **Exemple**: `0.45` = 45% (Belgique), `0.48` = 48% (France)
- **Description**: Prélèvement total actuel pour comparaison
- **Calcul**: Cotisations salariales + patronales + impôt moyen
- **Source**: OCDE, ministères des finances
- **Impact**: Base de comparaison année -1

---

### Section [Affichage]

#### `decimales_affichage`
- **Type**: Entier
- **Plage**: 0 à 4
- **Exemple**: `2`
- **Description**: Nombre de décimales dans les tableaux Markdown
- **Impact**: Lisibilité vs précision
- **Recommandation**: 2 pour la plupart des usages

---

## Méthodes de Calcul

### Multiplicateur des Pensions

**Problème**: La somme des flux bruts de pensions ne rembourse PAS exactement la dette implicite.

**Solution**: Calculer un multiplicateur qui ajuste les flux.

**Algorithme**:
1. Simuler tous les flux bruts sur la durée complète
2. Calculer: `multiplicateur = dette_implicite / somme(flux_bruts)`
3. Appliquer: `flux_réel = flux_brut × multiplicateur`

**Résultat**: Garantit que `Σ(flux_réel) = dette_implicite` exactement

**Exemple Belgique**: Multiplicateur = 2.9031
→ Les pensions sont payées ~2.9× plus que prévu pour rembourser la dette

### Calcul Annuel (Ordre Important)

```
Pour chaque année:
  1. Croissance PIB (base + bonus selon période)
  2. Nouvelle cohorte retraités (avec droits proportionnels)
  3. Mortalité des cohortes existantes
  4. Flux pensions total (avec multiplicateur)
  5. Plafond différentiel (selon méthode)
  6. Différentiel réel = max(plafond, flux_pensions / PIB)
  7. Si différentiel > flux:
       Excédent rembourse dettes (transition prioritaire)
  8. Si différentiel < flux:
       Emprunter la différence → dette transition
  9. Remboursement dette publique (1% PIB + excédent)
  10. Calcul intérêts (sur dettes réelles uniquement)
  11. Mise à jour dette implicite (diminue du flux payé)
  12. Arrêt si toutes dettes = 0
```

---

## Exemples de Configuration

### Belgique Conservative

```ini
[Economie]
taux_croissance_base = 0.012
bonus_croissance_1_10 = 0.015

[Financement]
privatisations_totales = 150.0
differentiel_initial = 0.12
duree_decroissance_differentiel = 50
```

**Résultat attendu**: ~85 ans, transition très progressive

### France Ambitieuse

```ini
[Economie]
taux_croissance_base = 0.018
bonus_croissance_1_10 = 0.025

[Financement]
privatisations_totales = 200.0
differentiel_initial = 0.08
duree_decroissance_differentiel = 35
methode_differentiel = quadratique_inverse
```

**Résultat attendu**: ~70 ans, transition rapide

---

## Interprétation des Résultats

### Fichier CSV

14 colonnes × N années

**Colonnes clés**:
- `differentiel_pct`: Impôt de transition (% PIB)
- `dette_publique_pct`: Dette réelle (génère intérêts)
- `dette_implicite_pct`: Dette nominale (engagement pensions)
- `interets_totaux`: Coût annuel de la dette

### Tableau Salaires

**Année -1**: Référence (système actuel)
**Évolution**: Prélèvement qui baisse progressivement
**Année finale**: Gain de pouvoir d'achat permanent

**Indicateur clé**: Gain % par tranche de salaire

---

## FAQ

**Q: Pourquoi le multiplicateur > 1 ?**
R: Car la dette implicite est calculée avec intérêts, mais les flux bruts ne les incluent pas.

**Q: La dette implicite génère-t-elle des intérêts ?**
R: NON. C'est un engagement futur, pas un emprunt bancaire.

**Q: Peut-on avoir différentiel < flux de pensions ?**
R: NON. Le différentiel = max(plafond, flux) par construction.

**Q: Pourquoi 4 assurances séparées ?**
R: Permet de moduler (ex: éducation selon nb enfants).

**Q: Que se passe-t-il après l'année finale ?**
R: Système stabilisé en capitalisation pure, différentiel = 0%.

**Q: Pourquoi les bas salaires perdent-ils au début ?**
R: Les assurances fixes (230€) pèsent proportionnellement plus lourd sur les petits salaires (11.5% de 2000€ vs 2.3% de 10000€). Cette inéquité temporaire nécessite des mesures d'accompagnement (crédit d'impôt, différentiel progressif) qui sortent du cadre de ce simulateur macro-économique. Voir fichier LIMITES_EQUITE.md pour l'analyse complète.

---

## ⚠️ Limites du Modèle

### Équité Sociale

**Le simulateur révèle une inéquité importante** : les bas salaires subissent une perte de pouvoir d'achat durant les 20-30 premières années, alors que les hauts salaires gagnent immédiatement.

**Pourquoi ?**
- Assurances fixes (230€/mois) = effet régressif
- Différentiel uniforme = même impact relatif

**Ce n'est PAS un bug, c'est une feature** : le simulateur révèle un vrai problème politique qui devra être traité par des mesures d'accompagnement :
- Crédit d'impôt temporaire
- Différentiel progressif par tranches
- Assurances dégressives
- Augmentation simultanée du SMIC

Voir **LIMITES_EQUITE.md** pour l'analyse complète et les solutions possibles.

### Simplifications Techniques

1. **Macro-économique uniquement**
   - Pas de distribution des salaires par déciles
   - Pas de comportements micro (élasticité)
   - Pas d'optimisation fiscale

2. **Hypothèses simplificatrices**
   - Inflation négligée (€ constants)
   - Pas de chocs (crises)
   - Mortalité linéaire

3. **Hors périmètre**
   - Mesures d'accompagnement social
   - Fiscalité locale/régionale
   - Effets sur l'emploi

**Le simulateur montre la faisabilité macro-économique, pas la perfection politique.**
