# Simulateur de Transition du Système de Pensions

## Utilisation avec fichiers INI

### Lancer une simulation

```bash
# Avec un fichier de configuration
python transition_pensions.py belgique_base.ini

# Sans fichier (utilise les paramètres par défaut)
python transition_pensions.py
```

### Scénarios disponibles

#### Belgique

- **belgique_base.ini** : Scénario de base avec paramètres réalistes
  
  - Croissance: 1.5% base + bonus réformes
  - Privatisations: 195 Mds €
  - Différentiel: 10% → 0% sur 40 ans (linéaire)
  - Durée: ~77 ans

- **belgique_optimiste.ini** : Scénario avec hypothèses favorables
  
  - Forte croissance: 2% base + bonus importants
  - Privatisations maximales: 250 Mds €
  - Différentiel: 8% → 0% sur 30 ans
  - Flat tax réduite: 23%
  - Durée estimée: ~60-65 ans

- **belgique_pessimiste.ini** : Scénario avec hypothèses défavorables
  
  - Croissance faible: 1% base + bonus réduits
  - Pas de privatisations
  - Différentiel: 12% → 0% sur 50 ans
  - Espérance de vie plus longue
  - Durée: ~84 ans

#### France

- **france_base.ini** : Simulation pour la France
  - PIB: 2800 Mds €
  - Dette publique: 3200 Mds €
  - Dette implicite: 7000 Mds €
  - 17 millions de retraités
  - Prélèvement actuel: 48%

### Créer votre propre scénario

1. Copiez un fichier INI existant
2. Modifiez les paramètres selon vos hypothèses
3. Lancez la simulation avec votre fichier

### Structure du fichier INI

```ini
[Pays]
nom = Nom du pays/scénario
description = Description courte

[Economie]
pib_initial = PIB initial en Mds €
dette_publique_initiale = Dette publique en Mds €
taux_croissance_base = Taux de croissance annuel de base
# ... autres paramètres de croissance

[Pensions]
dette_implicite_initiale = Dette implicite des pensions en Mds €
reduction_solidaire = Réduction appliquée aux pensions (0.10 = 10%)
nombre_retraites_initiaux = Nombre de retraités actuels
# ... autres paramètres démographiques

[Financement]
privatisations_totales = Montant des privatisations en Mds €
differentiel_initial = Différentiel initial (0.10 = 10% du PIB)
duree_decroissance_differentiel = Durée en années
methode_differentiel = lineaire | quadratique_inverse | exponentielle_inverse | paliers

[Salaires]
salaires_analyses = Liste des salaires à analyser (séparés par virgules)
taux_flat_tax = Taux de la flat tax (0.25 = 25%)
assurance_sante = Montant mensuel en €
# ... autres assurances
prelevement_actuel_total = Prélèvement actuel pour comparaison (0.45 = 45%)
```

### Fichiers générés

La simulation génère 3 fichiers dans `/mnt/user-data/outputs/`:

1. **transition_pensions.csv** : Données détaillées année par année
2. **transition_pensions.md** : Tableau récapitulatif (PIB, dettes, différentiel)
3. **transition_pensions_salaires.md** : Impact sur les salaires nets

### Paramètres clés à ajuster

**Pour un scénario optimiste:**

- Augmenter `taux_croissance_base` et les bonus
- Augmenter `privatisations_totales`
- Réduire `differentiel_initial` et `duree_decroissance_differentiel`
- Augmenter `reduction_solidaire`
- Augmenter `taux_mortalite_initial`

**Pour un scénario pessimiste:**

- Réduire les taux de croissance
- Réduire ou supprimer les privatisations
- Augmenter le différentiel et la durée
- Augmenter l'espérance de vie (réduire mortalité)

### Méthodes de décroissance du différentiel

- **lineaire** : Décroissance constante et prévisible
- **quadratique_inverse** : Décroissance lente au début, rapide à la fin
- **exponentielle_inverse** : Décroissance très lente au début
- **paliers** : Décroissance par paliers (nécessite paramètres spécifiques)

### Exemple de comparaison de scénarios

```bash
# Générer les 3 scénarios Belgique
python transition_pensions.py belgique_base.ini
# → Crée automatiquement resultats/belgique_base/
#    avec donnees.csv, tableaux.md, salaires.md, graphiques.svg

python transition_pensions.py belgique_optimiste.ini
# → Crée automatiquement resultats/belgique_optimiste/

python transition_pensions.py belgique_pessimiste.ini
# → Crée automatiquement resultats/belgique_pessimiste/### Notes importantes
```

- Les montants sont en **milliards d'euros** pour PIB et dettes
- Les montants sont en **euros mensuels** pour les salaires et assurances
- Les taux sont en **fraction** (0.10 = 10%, 0.25 = 25%)
- La simulation s'arrête quand toutes les dettes = 0
